/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.widget.Button;
import icyllis.modernui.widget.Checkable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CompoundButton
extends Button
implements Checkable {
    private boolean mChecked;
    private boolean mBroadcasting;
    private Drawable mButtonDrawable;
    private OnCheckedChangeListener mOnCheckedChangeListener;

    public CompoundButton() {
        this.setChecked(false);
    }

    @Override
    protected void onDraw(@Nonnull Canvas canvas) {
        Drawable buttonDrawable = this.mButtonDrawable;
        super.onDraw(canvas);
        if (buttonDrawable != null) {
            buttonDrawable.draw(canvas);
        }
    }

    @Override
    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            if (this.mBroadcasting) {
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
            this.mBroadcasting = false;
        }
    }

    @Override
    public final boolean isChecked() {
        return this.mChecked;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public void setButtonDrawable(@Nullable Drawable drawable) {
        if (this.mButtonDrawable != drawable) {
            this.mButtonDrawable = drawable;
        }
    }

    @Nullable
    public Drawable getButtonDrawable() {
        return this.mButtonDrawable;
    }

    @FunctionalInterface
    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }
}

